class Enemy_Scorpion expands Enemy;

#exec MESH IMPORT MESH=scorpion ANIVFILE=Models\Enemies\Scorpion\scorpion_a.3d DATAFILE=Models\Enemies\Scorpion\scorpion_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=scorpion X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=scorpion SEQ=All     STARTFRAME=0   NUMFRAMES=210  RATE=12
#exec MESH SEQUENCE MESH=scorpion SEQ=Attack1 STARTFRAME=196 NUMFRAMES=14   RATE=18
#exec MESH SEQUENCE MESH=scorpion SEQ=Attack2 STARTFRAME=16  NUMFRAMES=13   RATE=10
#exec MESH SEQUENCE MESH=scorpion SEQ=Attack3 STARTFRAME=29  NUMFRAMES=16   RATE=14 
#exec MESH SEQUENCE MESH=scorpion SEQ=Breathe STARTFRAME=45  NUMFRAMES=10   RATE=4
#exec MESH SEQUENCE MESH=scorpion SEQ=Death1  STARTFRAME=55  NUMFRAMES=19   RATE=12
#exec MESH SEQUENCE MESH=scorpion SEQ=Death2  STARTFRAME=74  NUMFRAMES=9    RATE=12
#exec MESH SEQUENCE MESH=scorpion SEQ=Hurt1   STARTFRAME=84  NUMFRAMES=4    RATE=12
#exec MESH SEQUENCE MESH=scorpion SEQ=Hurt2   STARTFRAME=88  NUMFRAMES=4    RATE=12
#exec MESH SEQUENCE MESH=scorpion SEQ=Hurt3   STARTFRAME=92  NUMFRAMES=4    RATE=12
#exec MESH SEQUENCE MESH=scorpion SEQ=Falling STARTFRAME=83  NUMFRAMES=1
#exec MESH SEQUENCE MESH=scorpion SEQ=Jump    STARTFRAME=96  NUMFRAMES=13   RATE=16	
#exec MESH SEQUENCE MESH=scorpion SEQ=Land    STARTFRAME=109 NUMFRAMES=7    RATE=28
#exec MESH SEQUENCE MESH=scorpion SEQ=Look    STARTFRAME=116 NUMFRAMES=26   RATE=8
#exec MESH SEQUENCE MESH=scorpion SEQ=Run     STARTFRAME=142 NUMFRAMES=24   RATE=24
#exec MESH SEQUENCE MESH=scorpion SEQ=Swim    STARTFRAME=166 NUMFRAMES=14   RATE=24
#exec MESH SEQUENCE MESH=scorpion SEQ=Swim2   STARTFRAME=180 NUMFRAMES=14   RATE=24
#exec MESH SEQUENCE MESH=scorpion SEQ=Swim3   STARTFRAME=194 NUMFRAMES=1    RATE=12
#exec MESH SEQUENCE MESH=scorpion SEQ=Swim4   STARTFRAME=195 NUMFRAMES=1    RATE=12
#exec MESH SEQUENCE MESH=scorpion SEQ=Swim5   STARTFRAME=180 NUMFRAMES=14   RATE=24
#exec MESH SEQUENCE MESH=scorpion SEQ=Walk    STARTFRAME=0   NUMFRAMES=16   RATE=14

#exec TEXTURE IMPORT NAME=Jscorpion1 FILE=Textures\Enemies\Scorpion\Jscorpion1.bmp GROUP=Skins FLAGS=2 // TWOSIDED
#exec MESHMAP NEW   MESHMAP=scorpion MESH=scorpion
#exec MESHMAP SCALE MESHMAP=scorpion X=0.1 Y=0.1 Z=0.2
//#exec MESHMAP SETTEXTURE MESHMAP=scorpion NUM=1 TEXTURE=Jscorpion1

#exec MESH NOTIFY MESH=scorpion SEQ=Attack1 TIME=0.7 FUNCTION=DoMeleeDamage
#exec MESH NOTIFY MESH=scorpion SEQ=Attack3 TIME=0.7 FUNCTION=ShootTarget
#exec MESH NOTIFY MESH=scorpion SEQ=Swim2   TIME=0.7 FUNCTION=ShootTarget
#exec MESH NOTIFY MESH=scorpion SEQ=Swim5   TIME=0.7 FUNCTION=DoMeleeDamage

var() byte BiteDamage;		
var(Sounds) sound LandSound;
var(Sounds) sound WaitSound;
var(Sounds) sound DieSound;
var(Sounds) sound SwingSound;

function PreSetMovement()
{
	bCanJump = true;
	bCanWalk = true;
	bCanSwim = true;
	bCanFly = false;
	MinHitWall = -0.6;
}

function JumpOffPawn()
{
	Super.JumpOffPawn();
	PlayAnim('Walk');
}

function SetMovementPhysics()
{
	if (Region.Zone.bWaterZone && (Physics != PHYS_Swimming) )
		SetPhysics(PHYS_Swimming);
	else if (Physics != PHYS_Walking)
		SetPhysics(PHYS_Walking); 
}



function JumpOutOfWater(vector jumpDir)
{
	Falling();
	Velocity = jumpDir * WaterSpeed;
	Acceleration = jumpDir * AccelRate;
	velocity.Z = 460; //set here so physics uses this for remainder of tick
	PlayOutOfWater();
	bUpAndOut = true;
}

function SetFall()
{
	if (Enemy != None)
	{
		NextState = 'Waiting'; //default
		NextLabel = 'Begin';
		NextAnim = 'Breathe';
		GotoState('FallingState');
	}
}

function PlayWaiting()
{
	local float decision;

	decision = FRand();

	if (Region.Zone.bWaterZone)
		LoopAnim('Swim');
	else
		if (decision < 0.5)
		{
			LoopAnim('Breathe');
			PlaySound(WaitSound,SLOT_Interact);
		} else {
			LoopAnim('Look');
			PlaySound(WaitSound,SLOT_Interact);
		}
}

function PlayPatrolStop()
{
	PlayWaiting();
}

function PlayWaitingAmbush()
{
	PlayWaiting();
}

function TweenToRunning(float tweentime)
{
	if (Region.Zone.bWaterZone)
		TweenAnim('Swim',tweentime);
	else if (AnimSequence != 'Run' || !bAnimLoop)
		TweenAnim('Run', tweentime);
}

function TweenToWalking(float tweentime)
{
	if (Region.Zone.bWaterZone)
		TweenAnim('Swim',tweentime);
	else
		TweenAnim('Walk',tweentime);
}

function TweenToWaiting(float tweentime)
{
	if (Region.Zone.bWaterZone)
		TweenAnim('Swim',tweentime);
	else
		TweenAnim('Breathe', tweentime);
}

function TweenToPatrolStop(float tweentime)
{
	if (Region.Zone.bWaterZone)
		TweenAnim('Swim',tweentime);
	else
		TweenAnim('Breathe', tweentime);
}

function TweenToFalling()
{
	TweenAnim('Land', 0.5);
}

function PlayInAir()
{
	TweenAnim('Falling', 0.5);
}

function PlayLanded(float impactVel)
{
	PlayAnim('Land', 0.5);
	PlaySound(LandSound, SLOT_Interact);
}

function PlayOutOfWater()
{
	PlayAnim('Jump');
}

function PlayDive()
{
	PlayAnim('Jump');
}

function PlayRunning()
{
	if (Region.Zone.bWaterZone)
		LoopAnim('Swim');
	else 
		LoopAnim('Run');	
}

function PlayWalking()
{
	if (Region.Zone.bWaterZone)
		LoopAnim('Swim');
	else
		LoopAnim('Walk');
}

function PlayThreatening()
{
	if (Region.Zone.bWaterZone)
		PlayAnim('Swim');
	else
		PlayWaiting();
}

function PlayTurning()
{
	if (Region.Zone.bWaterZone)
		TweenAnim('Swim', 0.5);
	else
		TweenAnim('Walk', 0.5);
}

function PlayDying(name DamageType, vector HitLocation)
{
	local float decision;

	decision = FRand();
	
	if (decision < 0.5)
		PlayAnim('Death1');
	else
		PlayAnim('Death2');

	PlaySound(DieSound,SLOT_Interact);
}

function PlayTakeHit(float tweentime, vector HitLoc, int damage)
{
	local float decision;
	
	decision = FRand();
	
	if (Region.Zone.bWaterZone)
	{
		if (decision < 0.5)
		{
			PlayAnim('Swim3');
			PlaySound(HitSound1,SLOT_Interact);
		} else {
			PlayAnim('Swim4');
			PlaySound(HitSound1,SLOT_Interact);
		}

	}
	else
	{
		if (decision < 0.3)
		{
			PlayAnim('Hit1');
			PlaySound(HitSound1,SLOT_Interact);
		} else if (decision <0.6) {
			PlayAnim('Hit2');
			PlaySound(HitSound2,SLOT_Interact);
		} else {
			PlayAnim('Hit3');
			PlaySound(HitSound1,SLOT_Interact);
		}
	}
}

function PlayVictoryDance()
{
	if (Region.Zone.bWaterZone)
		PlayAnim('Swim');
	else
		PlayAnim('Look');
}

function bool CanFireAtEnemy()
{
	local vector HitLocation, HitNormal, EnemyDir, projStart;
	local actor HitActor;
	local float EnemyDist;

	EnemyDir = Enemy.Location - Location + Enemy.CollisionHeight * vect(0,0,0.8);	
	EnemyDist = VSize(EnemyDir);
	if (EnemyDist > 750) //FIXME - what is right number?
		return false;
	
	EnemyDir = EnemyDir/EnemyDist;	
	projStart = Location + 0.8 * CollisionRadius * EnemyDir + 0.8 * CollisionHeight * vect(0,0,1);
	HitActor = Trace(HitLocation, HitNormal, 
				projStart + (MeleeRange + Enemy.CollisionRadius) * EnemyDir,
				projStart, false, vect(6,6,4) );

	return (HitActor == None);
}

function PlayMeleeAttack()
{
	local float dist, decision;

	decision = FRand();

	dist = VSize(Target.Location - Location);

	if (dist > CollisionRadius + Target.CollisionRadius + 45)		
		decision = 1.0;

	if (Region.Zone.bWaterZone)
		PlayAnim('Swim5');

	else 	{
		if (decision < 0.20)
		{
			PlayAnim('Attack2');
			PlaySound(SwingSound,SLOT_Interact);
			return;
		} else {
			PlayAnim('Attack1');
			PlaySound(SwingSound,SLOT_Interact);
		}
	}
}

function DoMeleeDamage()
{
	MeleeRange = 50;
	MeleeDamageTarget(BiteDamage, vect(0,0,0));
	MeleeRange = Default.MeleeRange;
}

function ShootTarget()
{
	FireProjectile( vect(1.0, 0, 0), 900);
}

function PlayRangedAttack()
{
	if (Region.Zone.bWaterZone)
		PlayAnim('Swim2');
	else
		PlayAnim('Attack3');
}

auto state StartUp
{
	function SetMovementPhysics()
	{
		SetPhysics(PHYS_None); // don't fall at start
	}
}

state Waiting
{
TurnFromWall:
	if ( NearWall(70) )
	{
		PlayTurning();
		TurnTo(Focus);
	}
Begin:
	TweenToWaiting(0.4);
	bReadyToAttack = false;
	if (Physics != PHYS_Walking) 
		SetPhysics(PHYS_None);
KeepWaiting:
	NextAnim = '';
}

defaultproperties
{
    HUDname="Scorpion"
	HUDcolor=(R=255,G=0,B=0)
    BiteDamage=10
    LandSound=Sound'UnrealI.Pupae.thumppp'
    WaitSound=Sound'UnrealI.Pupae.roam1pp'
    DieSound=Sound'UnrealI.Pupae.death1pp'
    SwingSound=Sound'UnrealShare.Manta.whip1m'
    Aggressiveness=10.00
    bHasRangedAttack=True
    bLeadTarget=False
    RangedProjectile=Class'UnrealShare.SlithProjectile'
    Acquire=Sound'scorp01'
    Fear=Sound'AntHit3'
    Roam=Sound'scorp01'
    Threaten=Sound'scorp01'
    MeleeRange=40.00
    GroundSpeed=200.00
    WaterSpeed=100.00
    JumpZ=280.00
    Visibility=100
    SightRadius=8500.00
    PeripheralVision=0.40
    Health=80
    Intelligence=3
    HitSound1=Sound'UnrealI.Pupae.injur1pp'
    HitSound2=Sound'UnrealI.Pupae.injur2pp'
    Die=Sound'AntHit3'
    CombatStyle=1.00
    //DrawType=2
	Texture=Texture'Jscorpion1'
    Mesh=LodMesh'Scorpion'
    CollisionRadius=32.00
    CollisionHeight=6.00
    Mass=80.00
    Buoyancy=80.00
}
